/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools;

import java.io.IOException;
import java.io.InputStream;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainApplication
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(MainApplication.class);

    public static void main(String[] args) {
        logger.trace("main() method called");
        MainApplication.launch(new String[0]);
    }

    @Override
    public void start(Stage stage) throws IOException {
        logger.info("=== PDF Tools Application Starting ===");
        logger.debug("JavaFX Version: {}", (Object)System.getProperty("javafx.version"));
        logger.debug("Java Version: {}", (Object)System.getProperty("java.version"));
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/datmt/pdftools/ui/main-screen.fxml"));
            Scene scene = new Scene((Parent)fxmlLoader.load(), 1000.0, 700.0);
            stage.setTitle("PDF Tools");
            stage.setScene(scene);
            this.loadAppIcon(stage);
            logger.info("Main window initialized");
            stage.show();
            stage.setOnCloseRequest(event -> logger.info("Application closing"));
        }
        catch (Exception e) {
            logger.error("Failed to start application", e);
            throw e;
        }
    }

    private void loadAppIcon(Stage stage) {
        String[] iconSizes;
        for (String size : iconSizes = new String[]{"256", "64", "32"}) {
            try (InputStream is = this.getClass().getResourceAsStream("/com/datmt/pdftools/icons/app-icon-" + size + ".png");){
                if (is == null) continue;
                stage.getIcons().add(new Image(is));
                logger.debug("Loaded app icon: app-icon-{}.png", (Object)size);
            }
            catch (Exception e) {
                logger.trace("Could not load icon size {}: {}", (Object)size, (Object)e.getMessage());
            }
        }
        if (stage.getIcons().isEmpty()) {
            try (InputStream is = this.getClass().getResourceAsStream("/com/datmt/pdftools/icons/app-icon.png");){
                if (is != null) {
                    stage.getIcons().add(new Image(is));
                    logger.debug("Loaded app icon: app-icon.png");
                }
            }
            catch (Exception e) {
                logger.warn("Could not load application icon: {}", (Object)e.getMessage());
            }
        }
    }
}

