/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.Image;
import org.apache.pdfbox.pdmodel.PDDocument;

public class JoinerFile {
    private final File sourceFile;
    private final FileType fileType;
    private final int pageCount;
    private PDDocument pdfDocument;
    private Image image;
    private final List<Image> thumbnailCache;

    public JoinerFile(File sourceFile, PDDocument pdfDocument) {
        this.sourceFile = sourceFile;
        this.fileType = FileType.PDF;
        this.pdfDocument = pdfDocument;
        this.pageCount = pdfDocument.getNumberOfPages();
        this.thumbnailCache = new ArrayList<Image>();
    }

    public JoinerFile(File sourceFile, Image image) {
        this.sourceFile = sourceFile;
        this.fileType = FileType.IMAGE;
        this.image = image;
        this.pageCount = 1;
        this.thumbnailCache = new ArrayList<Image>();
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getFileName() {
        return this.sourceFile.getName();
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isPdf() {
        return this.fileType == FileType.PDF;
    }

    public boolean isImage() {
        return this.fileType == FileType.IMAGE;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public PDDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public Image getImage() {
        return this.image;
    }

    public void cacheThumbnail(int pageIndex, Image thumbnail) {
        while (this.thumbnailCache.size() <= pageIndex) {
            this.thumbnailCache.add(null);
        }
        this.thumbnailCache.set(pageIndex, thumbnail);
    }

    public Image getCachedThumbnail(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.thumbnailCache.size()) {
            return this.thumbnailCache.get(pageIndex);
        }
        return null;
    }

    public void clearCache() {
        this.thumbnailCache.clear();
    }

    public void close() throws Exception {
        if (this.pdfDocument != null) {
            this.pdfDocument.close();
            this.pdfDocument = null;
        }
    }

    public String toString() {
        return this.getFileName() + " (" + this.pageCount + " page" + (this.pageCount > 1 ? "s" : "") + ")";
    }

    public static enum FileType {
        PDF,
        IMAGE;

    }
}

