/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.model;

import com.datmt.pdftools.model.JoinerFile;

public class JoinerSection {
    private final JoinerFile sourceFile;
    private int startPage;
    private int endPage;
    private PageSize pageSize = PageSize.A4;
    private FitOption fitOption = FitOption.FIT_TO_PAGE;
    private Rotation rotation = Rotation.NONE;

    public JoinerSection(JoinerFile sourceFile) {
        this.sourceFile = sourceFile;
        this.startPage = 0;
        this.endPage = sourceFile.getPageCount() - 1;
    }

    public JoinerSection(JoinerFile sourceFile, int startPage, int endPage) {
        this.sourceFile = sourceFile;
        this.startPage = Math.max(0, startPage);
        this.endPage = Math.min(endPage, sourceFile.getPageCount() - 1);
    }

    public JoinerFile getSourceFile() {
        return this.sourceFile;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = Math.max(0, startPage);
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = Math.min(endPage, this.sourceFile.getPageCount() - 1);
    }

    public int getPageCount() {
        return this.endPage - this.startPage + 1;
    }

    public boolean isAllPages() {
        return this.startPage == 0 && this.endPage == this.sourceFile.getPageCount() - 1;
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    public FitOption getFitOption() {
        return this.fitOption;
    }

    public void setFitOption(FitOption fitOption) {
        this.fitOption = fitOption;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public String getPageRangeString() {
        if (this.sourceFile.isImage()) {
            return "1 page";
        }
        if (this.isAllPages()) {
            return "all (" + this.getPageCount() + " pages)";
        }
        int startDisplay = this.startPage + 1;
        int endDisplay = this.endPage + 1;
        if (startDisplay == endDisplay) {
            return "page " + startDisplay;
        }
        return "pages " + startDisplay + "-" + endDisplay;
    }

    public String toString() {
        return this.sourceFile.getFileName() + ": " + this.getPageRangeString();
    }

    public static enum PageSize {
        A4("A4", 595.0f, 842.0f),
        LETTER("Letter", 612.0f, 792.0f),
        ORIGINAL("Original", 0.0f, 0.0f);

        private final String displayName;
        private final float width;
        private final float height;

        private PageSize(String displayName, float width, float height) {
            this.displayName = displayName;
            this.width = width;
            this.height = height;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum FitOption {
        FIT_TO_PAGE("Fit to page"),
        FILL_PAGE("Fill page"),
        ORIGINAL_SIZE("Original size");

        private final String displayName;

        private FitOption(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum Rotation {
        NONE(0),
        CW_90(90),
        CW_180(180),
        CW_270(270);

        private final int degrees;

        private Rotation(int degrees) {
            this.degrees = degrees;
        }

        public int getDegrees() {
            return this.degrees;
        }

        public String toString() {
            return this.degrees + "\u00b0";
        }
    }
}

