/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.model;

import java.util.ArrayList;
import java.util.List;

public class PdfBookmark {
    private String title;
    private int pageIndex;
    private int endPageIndex;
    private int level;
    private List<PdfBookmark> children;
    private boolean selected;

    public PdfBookmark(String title, int pageIndex, int level) {
        this.title = title;
        this.pageIndex = pageIndex;
        this.endPageIndex = pageIndex;
        this.level = level;
        this.children = new ArrayList<PdfBookmark>();
        this.selected = false;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getEndPageIndex() {
        return this.endPageIndex;
    }

    public void setEndPageIndex(int endPageIndex) {
        this.endPageIndex = endPageIndex;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public List<PdfBookmark> getChildren() {
        return this.children;
    }

    public void addChild(PdfBookmark child) {
        this.children.add(child);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getPageRangeString() {
        int startDisplay = this.pageIndex + 1;
        int endDisplay = this.endPageIndex + 1;
        if (startDisplay == endDisplay) {
            return "page " + startDisplay;
        }
        return "pages " + startDisplay + "-" + endDisplay;
    }

    public int getPageCount() {
        return this.endPageIndex - this.pageIndex + 1;
    }

    public String getSanitizedTitle() {
        return this.title.replaceAll("[^a-zA-Z0-9\\s\\-_]", "").replaceAll("\\s+", "_").trim();
    }

    public String toString() {
        return this.title + " (" + this.getPageRangeString() + ")";
    }
}

