/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.Image;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfDocument {
    private File sourceFile;
    private PDDocument pdfDocument;
    private int pageCount;
    private List<Image> pageImageCache;

    public PdfDocument(File sourceFile, PDDocument pdfDocument) {
        this.sourceFile = sourceFile;
        this.pdfDocument = pdfDocument;
        this.pageCount = pdfDocument.getNumberOfPages();
        this.pageImageCache = new ArrayList<Image>();
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public PDDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public List<Image> getPageImageCache() {
        return this.pageImageCache;
    }

    public void cachePageImage(int pageIndex, Image image) {
        while (this.pageImageCache.size() <= pageIndex) {
            this.pageImageCache.add(null);
        }
        this.pageImageCache.set(pageIndex, image);
    }

    public Image getCachedPageImage(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.pageImageCache.size()) {
            return this.pageImageCache.get(pageIndex);
        }
        return null;
    }

    public void clearCache() {
        this.pageImageCache.clear();
    }
}

