/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.model;

import java.io.File;

public class RenameItem {
    private final File originalFile;
    private String extractedTitle;
    private String newFilename;
    private RenameStatus status;
    private String errorMessage;

    public RenameItem(File originalFile) {
        this.originalFile = originalFile;
        this.extractedTitle = null;
        this.newFilename = originalFile.getName();
        this.status = RenameStatus.PENDING;
        this.errorMessage = null;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    public String getOriginalFilename() {
        return this.originalFile.getName();
    }

    public String getExtractedTitle() {
        return this.extractedTitle;
    }

    public void setExtractedTitle(String extractedTitle) {
        this.extractedTitle = extractedTitle;
    }

    public String getNewFilename() {
        return this.newFilename;
    }

    public void setNewFilename(String newFilename) {
        this.newFilename = newFilename;
    }

    public RenameStatus getStatus() {
        return this.status;
    }

    public void setStatus(RenameStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean needsRename() {
        return this.newFilename != null && !this.newFilename.equals(this.originalFile.getName());
    }

    public File getTargetFile() {
        return new File(this.originalFile.getParentFile(), this.newFilename);
    }

    public String toString() {
        return this.originalFile.getName() + " -> " + this.newFilename + " [" + String.valueOf((Object)this.status) + "]";
    }

    public static enum RenameStatus {
        PENDING,
        READY,
        NO_TITLE,
        SUCCESS,
        SKIPPED,
        ERROR;

    }
}

