/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.service;

import com.datmt.pdftools.model.PdfBookmark;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBookmarkService {
    private static final Logger logger = LoggerFactory.getLogger(PdfBookmarkService.class);

    public boolean hasBookmarks(PDDocument document) {
        if (document == null) {
            return false;
        }
        PDDocumentOutline outline = document.getDocumentCatalog().getDocumentOutline();
        return outline != null && outline.getFirstChild() != null;
    }

    public List<PdfBookmark> extractBookmarks(PDDocument document) {
        ArrayList<PdfBookmark> bookmarks = new ArrayList<PdfBookmark>();
        if (document == null) {
            return bookmarks;
        }
        PDDocumentOutline outline = document.getDocumentCatalog().getDocumentOutline();
        if (outline == null) {
            logger.debug("Document has no outline/bookmarks");
            return bookmarks;
        }
        int totalPages = document.getNumberOfPages();
        logger.info("Extracting bookmarks from document with {} pages", (Object)totalPages);
        this.extractBookmarksRecursive(outline, document, bookmarks, 0);
        this.calculatePageRanges(bookmarks, totalPages);
        logger.info("Extracted {} top-level bookmarks", (Object)bookmarks.size());
        return bookmarks;
    }

    private void extractBookmarksRecursive(PDOutlineNode node, PDDocument document, List<PdfBookmark> bookmarks, int level) {
        for (PDOutlineItem item = node.getFirstChild(); item != null; item = item.getNextSibling()) {
            String title = item.getTitle();
            int pageIndex = this.getPageIndex(item, document);
            if (title == null || title.trim().isEmpty()) continue;
            PdfBookmark bookmark = new PdfBookmark(title.trim(), pageIndex, level);
            bookmarks.add(bookmark);
            logger.trace("Found bookmark: '{}' at page {} (level {})", title, pageIndex + 1, level);
            if (item.getFirstChild() == null) continue;
            this.extractBookmarksRecursive(item, document, bookmark.getChildren(), level + 1);
        }
    }

    private int getPageIndex(PDOutlineItem item, PDDocument document) {
        try {
            PDPage page = item.findDestinationPage(document);
            if (page != null) {
                int index = document.getPages().indexOf(page);
                return Math.max(0, index);
            }
        }
        catch (IOException e) {
            logger.warn("Could not get destination page for bookmark: {}", (Object)item.getTitle(), (Object)e);
        }
        return 0;
    }

    private void calculatePageRanges(List<PdfBookmark> bookmarks, int totalPages) {
        this.calculatePageRangesRecursive(bookmarks, totalPages);
    }

    private void calculatePageRangesRecursive(List<PdfBookmark> bookmarks, int totalPages) {
        for (int i = 0; i < bookmarks.size(); ++i) {
            PdfBookmark current = bookmarks.get(i);
            if (i + 1 < bookmarks.size()) {
                PdfBookmark next = bookmarks.get(i + 1);
                current.setEndPageIndex(Math.max(current.getPageIndex(), next.getPageIndex() - 1));
            } else {
                current.setEndPageIndex(totalPages - 1);
            }
            if (!current.hasChildren()) continue;
            this.calculatePageRangesRecursive(current.getChildren(), current.getEndPageIndex() + 1);
        }
    }

    public List<PdfBookmark> flattenTopLevel(List<PdfBookmark> bookmarks) {
        return new ArrayList<PdfBookmark>(bookmarks);
    }

    public List<PdfBookmark> flattenAll(List<PdfBookmark> bookmarks) {
        ArrayList<PdfBookmark> flattened = new ArrayList<PdfBookmark>();
        this.flattenRecursive(bookmarks, flattened);
        return flattened;
    }

    private void flattenRecursive(List<PdfBookmark> bookmarks, List<PdfBookmark> flattened) {
        for (PdfBookmark bookmark : bookmarks) {
            flattened.add(bookmark);
            if (!bookmark.hasChildren()) continue;
            this.flattenRecursive(bookmark.getChildren(), flattened);
        }
    }

    public List<PdfBookmark> getSelectedBookmarks(List<PdfBookmark> bookmarks) {
        ArrayList<PdfBookmark> selected = new ArrayList<PdfBookmark>();
        this.collectSelectedRecursive(bookmarks, selected);
        return selected;
    }

    private void collectSelectedRecursive(List<PdfBookmark> bookmarks, List<PdfBookmark> selected) {
        for (PdfBookmark bookmark : bookmarks) {
            if (bookmark.isSelected()) {
                selected.add(bookmark);
            }
            if (!bookmark.hasChildren()) continue;
            this.collectSelectedRecursive(bookmark.getChildren(), selected);
        }
    }
}

