/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.service;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCompressor {
    private static final Logger logger = LoggerFactory.getLogger(PdfCompressor.class);
    private static final int THREAD_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressResult compress(File inputFile, File outputFile, CompressionOptions options, ProgressCallback callback) {
        logger.info("Compressing PDF: {} with level {} using {} threads", new Object[]{inputFile.getName(), options.getLevel(), THREAD_COUNT});
        long originalSize = inputFile.length();
        ExecutorService executor = Executors.newFixedThreadPool(THREAD_COUNT);
        try {
            CompressResult compressResult;
            block21: {
                PDDocument document = Loader.loadPDF(new RandomAccessReadBufferedFile(inputFile));
                try {
                    int totalPages = document.getNumberOfPages();
                    AtomicInteger completedPages = new AtomicInteger(0);
                    ArrayList futures = new ArrayList();
                    int i = 0;
                    while (i < totalPages) {
                        int n = i++;
                        Future<?> future = executor.submit(() -> {
                            try {
                                PDPage page = document.getPage(pageIndex);
                                this.compressPageImages(document, page, options);
                                int done = completedPages.incrementAndGet();
                                if (callback != null && done % 50 == 0) {
                                    callback.onProgress(done, totalPages, "Optimizing pages");
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Failed to compress page {}: {}", (Object)pageIndex, (Object)e.getMessage());
                            }
                        });
                        futures.add(future);
                    }
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            logger.warn("Page task failed: {}", (Object)e.getMessage());
                        }
                    }
                    if (callback != null) {
                        callback.onProgress(totalPages, totalPages, "Pages optimized");
                    }
                    if (options.isRemoveMetadata()) {
                        if (callback != null) {
                            callback.onProgress(totalPages, totalPages, "Removing metadata");
                        }
                        this.removeMetadata(document);
                    }
                    if (options.isRemoveBookmarks()) {
                        if (callback != null) {
                            callback.onProgress(totalPages, totalPages, "Removing bookmarks");
                        }
                        document.getDocumentCatalog().setDocumentOutline(null);
                    }
                    if (callback != null) {
                        callback.onProgress(totalPages, totalPages, "Saving compressed file");
                    }
                    document.save(outputFile);
                    long compressedSize = outputFile.length();
                    double reduction = (1.0 - (double)compressedSize / (double)originalSize) * 100.0;
                    logger.info("Compression complete: {} -> {} bytes ({}% reduction)", originalSize, compressedSize, String.format("%.1f", reduction));
                    compressResult = new CompressResult(inputFile, outputFile, originalSize, compressedSize);
                    if (document == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (document != null) {
                            try {
                                document.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.error("Failed to compress PDF {}: {}", inputFile.getName(), e.getMessage(), e);
                        CompressResult compressResult2 = new CompressResult(inputFile, e.getMessage());
                        return compressResult2;
                    }
                }
                document.close();
            }
            return compressResult;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void compressPageImages(PDDocument document, PDPage page, CompressionOptions options) throws IOException {
        PDXObject xobject;
        PDResources resources = page.getResources();
        if (resources == null) {
            return;
        }
        ArrayList<COSName> imageNames = new ArrayList<COSName>();
        for (COSName name : resources.getXObjectNames()) {
            xobject = resources.getXObject(name);
            if (!(xobject instanceof PDImageXObject)) continue;
            imageNames.add(name);
        }
        for (COSName name : imageNames) {
            try {
                xobject = resources.getXObject(name);
                if (!(xobject instanceof PDImageXObject)) continue;
                PDImageXObject image = (PDImageXObject)xobject;
                this.compressImage(document, resources, name, image, options);
            }
            catch (Exception e) {
                logger.trace("Skipping image {}: {}", (Object)name.getName(), (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressImage(PDDocument document, PDResources resources, COSName name, PDImageXObject originalImage, CompressionOptions options) {
        try {
            BufferedImage bufferedImage = originalImage.getImage();
            if (bufferedImage == null) {
                return;
            }
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            int maxDpi = options.getLevel().getMaxDpi();
            float scale = this.calculateScale(originalImage, maxDpi);
            BufferedImage processedImage = bufferedImage;
            if (scale < 1.0f) {
                int newWidth = Math.max(1, (int)((float)width * scale));
                int newHeight = Math.max(1, (int)((float)height * scale));
                processedImage = this.resizeImage(bufferedImage, newWidth, newHeight);
                logger.trace("Downscaled image from {}x{} to {}x{}", width, height, newWidth, newHeight);
            }
            if (processedImage.getColorModel().hasAlpha()) {
                BufferedImage rgbImage = new BufferedImage(processedImage.getWidth(), processedImage.getHeight(), 1);
                Graphics2D g = rgbImage.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, rgbImage.getWidth(), rgbImage.getHeight());
                g.drawImage((Image)processedImage, 0, 0, null);
                g.dispose();
                processedImage = rgbImage;
            }
            PDDocument pDDocument = document;
            synchronized (pDDocument) {
                PDImageXObject compressedImage = JPEGFactory.createFromImage(document, processedImage, options.getImageQuality());
                resources.put(name, compressedImage);
            }
        }
        catch (Exception e) {
            logger.trace("Skipping image {}: {}", (Object)name.getName(), (Object)e.getMessage());
        }
    }

    private float calculateScale(PDImageXObject image, int maxDpi) {
        float estimatedDpi = (float)Math.max(image.getWidth(), image.getHeight()) / 8.0f;
        if (estimatedDpi > (float)maxDpi) {
            return (float)maxDpi / estimatedDpi;
        }
        return 1.0f;
    }

    private BufferedImage resizeImage(BufferedImage original, int width, int height) {
        BufferedImage resized = new BufferedImage(width, height, original.getType() == 0 ? 1 : original.getType());
        Graphics2D g = resized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(original, 0, 0, width, height, null);
        g.dispose();
        return resized;
    }

    private void removeMetadata(PDDocument document) {
        PDDocumentInformation info = new PDDocumentInformation();
        document.setDocumentInformation(info);
        try {
            document.getDocumentCatalog().setMetadata(null);
        }
        catch (Exception e) {
            logger.warn("Could not remove XMP metadata: {}", (Object)e.getMessage());
        }
    }

    public static String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    public static class CompressionOptions {
        private CompressionLevel level = CompressionLevel.MEDIUM;
        private float imageQuality = 0.65f;
        private boolean removeMetadata = false;
        private boolean removeBookmarks = false;

        public CompressionLevel getLevel() {
            return this.level;
        }

        public void setLevel(CompressionLevel level) {
            this.level = level;
            this.imageQuality = level.getImageQuality();
        }

        public float getImageQuality() {
            return this.imageQuality;
        }

        public void setImageQuality(float imageQuality) {
            this.imageQuality = Math.max(0.1f, Math.min(1.0f, imageQuality));
        }

        public boolean isRemoveMetadata() {
            return this.removeMetadata;
        }

        public void setRemoveMetadata(boolean removeMetadata) {
            this.removeMetadata = removeMetadata;
        }

        public boolean isRemoveBookmarks() {
            return this.removeBookmarks;
        }

        public void setRemoveBookmarks(boolean removeBookmarks) {
            this.removeBookmarks = removeBookmarks;
        }
    }

    public static enum CompressionLevel {
        LOW(0.85f, 200),
        MEDIUM(0.65f, 150),
        HIGH(0.45f, 100);

        private final float imageQuality;
        private final int maxDpi;

        private CompressionLevel(float imageQuality, int maxDpi) {
            this.imageQuality = imageQuality;
            this.maxDpi = maxDpi;
        }

        public float getImageQuality() {
            return this.imageQuality;
        }

        public int getMaxDpi() {
            return this.maxDpi;
        }
    }

    @FunctionalInterface
    public static interface ProgressCallback {
        public void onProgress(int var1, int var2, String var3);
    }

    public static class CompressResult {
        private final File inputFile;
        private final File outputFile;
        private final long originalSize;
        private final long compressedSize;
        private final boolean success;
        private final String errorMessage;

        public CompressResult(File inputFile, File outputFile, long originalSize, long compressedSize) {
            this.inputFile = inputFile;
            this.outputFile = outputFile;
            this.originalSize = originalSize;
            this.compressedSize = compressedSize;
            this.success = true;
            this.errorMessage = null;
        }

        public CompressResult(File inputFile, String errorMessage) {
            this.inputFile = inputFile;
            this.outputFile = null;
            this.originalSize = inputFile.length();
            this.compressedSize = 0L;
            this.success = false;
            this.errorMessage = errorMessage;
        }

        public File getInputFile() {
            return this.inputFile;
        }

        public File getOutputFile() {
            return this.outputFile;
        }

        public long getOriginalSize() {
            return this.originalSize;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public double getCompressionRatio() {
            if (this.originalSize == 0L) {
                return 0.0;
            }
            return 1.0 - (double)this.compressedSize / (double)this.originalSize;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

