/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.service;

import com.datmt.pdftools.model.PdfDocument;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfLoader {
    private static final Logger logger = LoggerFactory.getLogger(PdfLoader.class);

    public PdfDocument loadPdf(File file) throws IOException {
        logger.debug("Loading PDF file: {}", (Object)file.getAbsolutePath());
        if (!file.exists()) {
            logger.error("PDF file does not exist: {}", (Object)file.getAbsolutePath());
            throw new IOException("File does not exist: " + file.getAbsolutePath());
        }
        if (!file.getName().toLowerCase().endsWith(".pdf")) {
            logger.warn("File does not have .pdf extension: {}", (Object)file.getName());
        }
        try {
            logger.trace("Using Loader.loadPDF() with RandomAccessReadBufferedFile");
            PDDocument pdfDocument = Loader.loadPDF(new RandomAccessReadBufferedFile(file));
            logger.info("Successfully loaded PDF: {} with {} pages", (Object)file.getName(), (Object)pdfDocument.getNumberOfPages());
            return new PdfDocument(file, pdfDocument);
        }
        catch (IOException e) {
            logger.error("Failed to load PDF file: {}", (Object)file.getAbsolutePath(), (Object)e);
            throw e;
        }
    }
}

