/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.service;

import com.datmt.pdftools.model.PdfDocument;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfRenderService {
    private static final Logger logger = LoggerFactory.getLogger(PdfRenderService.class);
    private static final int DEFAULT_DPI = 150;
    private static final int THUMBNAIL_DPI = 72;

    public Image renderPageToImage(PdfDocument pdfDocument, int pageIndex) throws IOException {
        logger.trace("Rendering page {} to image at {}DPI", (Object)pageIndex, (Object)150);
        return this.renderPageToImage(pdfDocument, pageIndex, 150);
    }

    public Image renderPageToThumbnail(PdfDocument pdfDocument, int pageIndex) throws IOException {
        logger.trace("Rendering page {} to thumbnail at {}DPI", (Object)pageIndex, (Object)72);
        return this.renderPageToImage(pdfDocument, pageIndex, 72);
    }

    private Image renderPageToImage(PdfDocument pdfDocument, int pageIndex, int dpi) throws IOException {
        if (pageIndex < 0 || pageIndex >= pdfDocument.getPageCount()) {
            logger.error("Page index out of range: {} (document has {} pages)", (Object)pageIndex, (Object)pdfDocument.getPageCount());
            throw new IllegalArgumentException("Page index out of range: " + pageIndex);
        }
        logger.debug("Rendering page {} at {}DPI", (Object)pageIndex, (Object)dpi);
        try {
            PDFRenderer renderer = new PDFRenderer(pdfDocument.getPdfDocument());
            BufferedImage bufferedImage = renderer.renderImageWithDPI(pageIndex, dpi, ImageType.RGB);
            WritableImage fxImage = SwingFXUtils.toFXImage(bufferedImage, null);
            logger.trace("Successfully rendered page {} to image", (Object)pageIndex);
            return fxImage;
        }
        catch (IOException e) {
            logger.error("Failed to render page {}: {}", pageIndex, e.getMessage(), e);
            throw e;
        }
    }

    public double[] getPageDimensions(PdfDocument pdfDocument, int pageIndex) {
        logger.trace("Getting dimensions for page {}", (Object)pageIndex);
        try {
            PDPage page = pdfDocument.getPdfDocument().getPage(pageIndex);
            PDRectangle mediaBox = page.getMediaBox();
            return new double[]{mediaBox.getWidth(), mediaBox.getHeight()};
        }
        catch (Exception e) {
            logger.error("Failed to get page dimensions for page {}: {}", (Object)pageIndex, (Object)e.getMessage());
            return new double[]{595.0, 842.0};
        }
    }
}

