/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.service;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSecurityService {
    private static final Logger logger = LoggerFactory.getLogger(PdfSecurityService.class);
    private static final int KEY_LENGTH = 256;

    public boolean isProtected(File file) {
        boolean bl;
        block8: {
            PDDocument doc = Loader.loadPDF(new RandomAccessReadBufferedFile(file));
            try {
                bl = doc.isEncrypted();
                if (doc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (doc != null) {
                        try {
                            doc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return true;
                }
            }
            doc.close();
        }
        return bl;
    }

    public SecurityInfo getSecurityInfo(File file, String password) throws IOException {
        try (PDDocument doc = this.loadDocument(file, password);){
            if (!doc.isEncrypted()) {
                SecurityInfo securityInfo = new SecurityInfo(false, false, false, null);
                return securityInfo;
            }
            AccessPermission ap = doc.getCurrentAccessPermission();
            Permissions perms = new Permissions();
            perms.setCanPrint(ap.canPrint());
            perms.setCanCopy(ap.canExtractContent());
            perms.setCanModify(ap.canModify());
            perms.setCanFillForms(ap.canFillInForm());
            boolean hasUserPassword = password != null && !password.isEmpty();
            SecurityInfo securityInfo = new SecurityInfo(true, hasUserPassword, true, perms);
            return securityInfo;
        }
    }

    public void protectPdf(File inputFile, File outputFile, String userPassword, String ownerPassword, Permissions permissions) throws IOException {
        logger.info("Protecting PDF: {} -> {}", (Object)inputFile.getName(), (Object)outputFile.getName());
        try (PDDocument doc = Loader.loadPDF(new RandomAccessReadBufferedFile(inputFile));){
            AccessPermission ap = permissions.toAccessPermission();
            StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword != null ? userPassword : "", ap);
            policy.setEncryptionKeyLength(256);
            doc.protect(policy);
            doc.save(outputFile);
            logger.info("Successfully protected PDF: {}", (Object)outputFile.getName());
        }
    }

    public void removeProtection(File inputFile, File outputFile, String password) throws IOException {
        logger.info("Removing protection from PDF: {} -> {}", (Object)inputFile.getName(), (Object)outputFile.getName());
        try (PDDocument doc = this.loadDocument(inputFile, password);){
            doc.setAllSecurityToBeRemoved(true);
            doc.save(outputFile);
            logger.info("Successfully removed protection from PDF: {}", (Object)outputFile.getName());
        }
    }

    public boolean verifyPassword(File file, String password) {
        boolean bl;
        block8: {
            PDDocument doc = this.loadDocument(file, password);
            try {
                bl = true;
                if (doc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (doc != null) {
                        try {
                            doc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            doc.close();
        }
        return bl;
    }

    private PDDocument loadDocument(File file, String password) throws IOException {
        if (password == null || password.isEmpty()) {
            return Loader.loadPDF(new RandomAccessReadBufferedFile(file));
        }
        return Loader.loadPDF((RandomAccessRead)new RandomAccessReadBufferedFile(file), password);
    }

    public static class SecurityInfo {
        private final boolean isEncrypted;
        private final boolean hasUserPassword;
        private final boolean hasOwnerPassword;
        private final Permissions permissions;

        public SecurityInfo(boolean isEncrypted, boolean hasUserPassword, boolean hasOwnerPassword, Permissions permissions) {
            this.isEncrypted = isEncrypted;
            this.hasUserPassword = hasUserPassword;
            this.hasOwnerPassword = hasOwnerPassword;
            this.permissions = permissions;
        }

        public boolean isEncrypted() {
            return this.isEncrypted;
        }

        public boolean hasUserPassword() {
            return this.hasUserPassword;
        }

        public boolean hasOwnerPassword() {
            return this.hasOwnerPassword;
        }

        public Permissions getPermissions() {
            return this.permissions;
        }
    }

    public static class Permissions {
        private boolean canPrint = true;
        private boolean canCopy = true;
        private boolean canModify = false;
        private boolean canFillForms = true;

        public boolean isCanPrint() {
            return this.canPrint;
        }

        public void setCanPrint(boolean canPrint) {
            this.canPrint = canPrint;
        }

        public boolean isCanCopy() {
            return this.canCopy;
        }

        public void setCanCopy(boolean canCopy) {
            this.canCopy = canCopy;
        }

        public boolean isCanModify() {
            return this.canModify;
        }

        public void setCanModify(boolean canModify) {
            this.canModify = canModify;
        }

        public boolean isCanFillForms() {
            return this.canFillForms;
        }

        public void setCanFillForms(boolean canFillForms) {
            this.canFillForms = canFillForms;
        }

        public AccessPermission toAccessPermission() {
            AccessPermission ap = new AccessPermission();
            ap.setCanPrint(this.canPrint);
            ap.setCanPrintFaithful(this.canPrint);
            ap.setCanExtractContent(this.canCopy);
            ap.setCanExtractForAccessibility(this.canCopy);
            ap.setCanModify(this.canModify);
            ap.setCanModifyAnnotations(this.canModify);
            ap.setCanFillInForm(this.canFillForms);
            ap.setCanAssembleDocument(this.canModify);
            return ap;
        }
    }
}

