/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.service;

import com.datmt.pdftools.model.PdfBookmark;
import com.datmt.pdftools.model.PdfDocument;
import com.datmt.pdftools.service.PdfBookmarkService;
import com.datmt.pdftools.service.PdfExtractor;
import com.datmt.pdftools.service.PdfLoader;
import com.datmt.pdftools.service.PdfRenderService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfService {
    private static final Logger logger = LoggerFactory.getLogger(PdfService.class);
    private final PdfLoader loader;
    private final PdfExtractor extractor;
    private final PdfRenderService renderService;
    private final PdfBookmarkService bookmarkService;
    private PdfDocument currentDocument;
    private List<PdfBookmark> currentBookmarks;

    public PdfService() {
        logger.trace("Initializing PdfService");
        this.loader = new PdfLoader();
        this.extractor = new PdfExtractor();
        this.renderService = new PdfRenderService();
        this.bookmarkService = new PdfBookmarkService();
        this.currentDocument = null;
        this.currentBookmarks = new ArrayList<PdfBookmark>();
    }

    public PdfDocument loadPdf(File file) throws IOException {
        logger.info("PdfService.loadPdf() called for: {}", (Object)file.getName());
        this.closeDocument();
        this.currentDocument = this.loader.loadPdf(file);
        this.currentBookmarks = this.bookmarkService.extractBookmarks(this.currentDocument.getPdfDocument());
        logger.info("Loaded document with {} bookmarks", (Object)this.currentBookmarks.size());
        return this.currentDocument;
    }

    public PdfDocument getCurrentDocument() {
        return this.currentDocument;
    }

    public boolean isDocumentLoaded() {
        return this.currentDocument != null;
    }

    public Image renderPage(int pageIndex) throws IOException {
        if (!this.isDocumentLoaded()) {
            logger.error("Cannot render page: no document loaded");
            throw new IllegalStateException("No PDF document loaded");
        }
        logger.debug("Rendering page {} from current document", (Object)pageIndex);
        return this.renderService.renderPageToImage(this.currentDocument, pageIndex);
    }

    public Image renderPageThumbnail(int pageIndex) throws IOException {
        if (!this.isDocumentLoaded()) {
            logger.error("Cannot render thumbnail: no document loaded");
            throw new IllegalStateException("No PDF document loaded");
        }
        logger.debug("Rendering thumbnail for page {}", (Object)pageIndex);
        return this.renderService.renderPageToThumbnail(this.currentDocument, pageIndex);
    }

    public double[] getPageDimensions(int pageIndex) {
        if (!this.isDocumentLoaded()) {
            logger.warn("Cannot get dimensions: no document loaded");
            return new double[]{595.0, 842.0};
        }
        return this.renderService.getPageDimensions(this.currentDocument, pageIndex);
    }

    public void extractPages(Set<Integer> pageIndices, File outputFile) throws IOException {
        this.extractPages(pageIndices, new HashMap<Integer, Integer>(), outputFile);
    }

    public void extractPages(Set<Integer> pageIndices, Map<Integer, Integer> rotations, File outputFile) throws IOException {
        if (!this.isDocumentLoaded()) {
            logger.error("Cannot extract pages: no document loaded");
            throw new IllegalStateException("No PDF document loaded");
        }
        logger.info("Extracting {} pages to: {} with {} rotations", pageIndices.size(), outputFile.getAbsolutePath(), rotations.size());
        this.extractor.extractPages(this.currentDocument, pageIndices, rotations, outputFile);
    }

    public void extractSinglePage(int pageIndex, File outputFile) throws IOException {
        if (!this.isDocumentLoaded()) {
            logger.error("Cannot extract page: no document loaded");
            throw new IllegalStateException("No PDF document loaded");
        }
        logger.info("Extracting single page {} to: {}", (Object)pageIndex, (Object)outputFile.getAbsolutePath());
        this.extractor.extractSinglePage(this.currentDocument, pageIndex, outputFile);
    }

    public void extractPageRange(int startPage, int endPage, File outputFile) throws IOException {
        if (!this.isDocumentLoaded()) {
            logger.error("Cannot extract range: no document loaded");
            throw new IllegalStateException("No PDF document loaded");
        }
        logger.info("Extracting page range {} to {} to: {}", startPage, endPage, outputFile.getAbsolutePath());
        this.extractor.extractPageRange(this.currentDocument, startPage, endPage, outputFile);
    }

    public boolean hasBookmarks() {
        return !this.currentBookmarks.isEmpty();
    }

    public List<PdfBookmark> getBookmarks() {
        return this.currentBookmarks;
    }

    public PdfBookmarkService getBookmarkService() {
        return this.bookmarkService;
    }

    public void extractByBookmarks(List<PdfBookmark> bookmarks, File outputDir) throws IOException {
        if (!this.isDocumentLoaded()) {
            logger.error("Cannot extract by bookmarks: no document loaded");
            throw new IllegalStateException("No PDF document loaded");
        }
        logger.info("Extracting {} bookmarks to: {}", (Object)bookmarks.size(), (Object)outputDir.getAbsolutePath());
        this.extractor.extractByBookmarks(this.currentDocument, bookmarks, outputDir);
    }

    public void closeDocument() {
        if (this.currentDocument != null) {
            logger.info("Closing document: {}", (Object)this.currentDocument.getSourceFile().getName());
            try {
                this.currentDocument.getPdfDocument().close();
                this.currentDocument.clearCache();
                this.currentDocument = null;
                this.currentBookmarks = new ArrayList<PdfBookmark>();
            }
            catch (Exception e) {
                logger.error("Error closing document: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

