/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.ui.controller;

import com.datmt.pdftools.util.CreditLinkHandler;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainScreenController {
    private static final Logger logger = LoggerFactory.getLogger(MainScreenController.class);
    public Button extractorButton;
    public Button joinerButton;
    public Button compressorButton;
    public Button securityButton;
    public Button inserterButton;
    public Button renamerButton;
    @FXML
    private Hyperlink creditLink;

    @FXML
    public void initialize() {
        CreditLinkHandler.setup(this.creditLink);
    }

    public void onExtractorClicked() {
        logger.info("User clicked PDF Extractor button");
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/datmt/pdftools/ui/extractor/pdf-extractor.fxml"));
            Scene scene = new Scene((Parent)fxmlLoader.load(), 1400.0, 800.0);
            Stage stage = new Stage();
            stage.setTitle("PDF Extractor");
            stage.setScene(scene);
            stage.setMinWidth(1400.0);
            stage.setMinHeight(800.0);
            stage.show();
            logger.info("PDF Extractor window opened");
        }
        catch (IOException e) {
            logger.error("Failed to load PDF Extractor window", e);
        }
    }

    public void onJoinerClicked() {
        logger.info("User clicked PDF Joiner button");
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/datmt/pdftools/ui/joiner/pdf-joiner.fxml"));
            Scene scene = new Scene((Parent)fxmlLoader.load(), 1400.0, 800.0);
            Stage stage = new Stage();
            stage.setTitle("PDF Joiner");
            stage.setScene(scene);
            stage.setMinWidth(1400.0);
            stage.setMinHeight(800.0);
            stage.show();
            logger.info("PDF Joiner window opened");
        }
        catch (IOException e) {
            logger.error("Failed to load PDF Joiner window", e);
        }
    }

    public void onCompressorClicked() {
        logger.info("User clicked PDF Compressor button");
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/datmt/pdftools/ui/compressor/pdf-compressor.fxml"));
            Scene scene = new Scene((Parent)fxmlLoader.load(), 900.0, 700.0);
            Stage stage = new Stage();
            stage.setTitle("PDF Compressor");
            stage.setScene(scene);
            stage.setMinWidth(900.0);
            stage.setMinHeight(700.0);
            stage.show();
            logger.info("PDF Compressor window opened");
        }
        catch (IOException e) {
            logger.error("Failed to load PDF Compressor window", e);
        }
    }

    public void onSecurityClicked() {
        logger.info("User clicked PDF Security button");
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/datmt/pdftools/ui/security/pdf-security.fxml"));
            Scene scene = new Scene((Parent)fxmlLoader.load(), 800.0, 600.0);
            Stage stage = new Stage();
            stage.setTitle("PDF Security");
            stage.setScene(scene);
            stage.setMinWidth(800.0);
            stage.setMinHeight(600.0);
            stage.show();
            logger.info("PDF Security window opened");
        }
        catch (IOException e) {
            logger.error("Failed to load PDF Security window", e);
        }
    }

    public void onInserterClicked() {
        logger.info("User clicked PDF Bulk Inserter button");
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/datmt/pdftools/ui/inserter/pdf-bulk-inserter.fxml"));
            Scene scene = new Scene((Parent)fxmlLoader.load(), 1000.0, 700.0);
            Stage stage = new Stage();
            stage.setTitle("PDF Bulk Inserter");
            stage.setScene(scene);
            stage.setMinWidth(900.0);
            stage.setMinHeight(600.0);
            stage.show();
            logger.info("PDF Bulk Inserter window opened");
        }
        catch (IOException e) {
            logger.error("Failed to load PDF Bulk Inserter window", e);
        }
    }

    public void onRenamerClicked() {
        logger.info("User clicked PDF Bulk Renamer button");
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/datmt/pdftools/ui/renamer/pdf-bulk-renamer.fxml"));
            Scene scene = new Scene((Parent)fxmlLoader.load(), 1100.0, 700.0);
            Stage stage = new Stage();
            stage.setTitle("PDF Bulk Renamer");
            stage.setScene(scene);
            stage.setMinWidth(1000.0);
            stage.setMinHeight(600.0);
            stage.show();
            logger.info("PDF Bulk Renamer window opened");
        }
        catch (IOException e) {
            logger.error("Failed to load PDF Bulk Renamer window", e);
        }
    }
}

