/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.ui.extractor.components;

import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageThumbnailPanel
extends VBox {
    private static final Logger logger = LoggerFactory.getLogger(PageThumbnailPanel.class);
    private static final int THUMBNAIL_SIZE = 100;
    private CheckBox selectCheckBox;
    private ImageView imageView;
    private Label pageLabel;
    private int pageNumber;
    private int pageIndex;
    private boolean imageLoaded;
    private int rotation;
    private Consumer<Void> onThumbnailClicked;
    private static final String BORDER_UNSELECTED = "-fx-border-color: #e0e0e0; -fx-border-radius: 3; -fx-padding: 5; -fx-cursor: hand;";
    private static final String BORDER_SELECTED = "-fx-border-color: #2196F3; -fx-border-radius: 3; -fx-padding: 5; -fx-border-width: 2; -fx-cursor: hand;";

    public PageThumbnailPanel(int pageNumber, Image thumbnail, Consumer<Boolean> onSelected) {
        this(pageNumber, thumbnail, onSelected, null);
    }

    public PageThumbnailPanel(int pageNumber, Image thumbnail, Consumer<Boolean> onSelected, Consumer<Void> onThumbnailClicked) {
        logger.trace("Creating thumbnail panel for page {}", (Object)pageNumber);
        this.pageNumber = pageNumber;
        this.pageIndex = pageNumber - 1;
        this.onThumbnailClicked = onThumbnailClicked;
        this.imageLoaded = thumbnail != null;
        this.setSpacing(5.0);
        this.setAlignment(Pos.TOP_CENTER);
        this.setStyle(BORDER_UNSELECTED);
        this.imageView = new ImageView(thumbnail);
        this.imageView.setPreserveRatio(true);
        this.imageView.setFitWidth(100.0);
        this.imageView.setFitHeight(100.0);
        this.selectCheckBox = new CheckBox();
        this.selectCheckBox.setStyle("-fx-cursor: default;");
        this.selectCheckBox.selectedProperty().addListener((obs, oldVal, newVal) -> {
            logger.trace("Page {} thumbnail checkbox changed to: {}", (Object)pageNumber, newVal);
            onSelected.accept((Boolean)newVal);
        });
        this.pageLabel = new Label("Page " + pageNumber);
        this.pageLabel.setStyle("-fx-font-weight: bold; -fx-font-size: 12;");
        this.rotation = 0;
        this.getChildren().addAll((Node[])new Node[]{this.imageView, this.selectCheckBox, this.pageLabel});
        this.setOnMouseClicked(event -> {
            if (event.getTarget() != this.selectCheckBox && !this.selectCheckBox.contains(event.getX(), event.getY())) {
                event.consume();
                if (onThumbnailClicked != null) {
                    logger.trace("Page {} thumbnail clicked", (Object)pageNumber);
                    onThumbnailClicked.accept(null);
                }
            }
        });
    }

    public boolean isSelected() {
        return this.selectCheckBox.isSelected();
    }

    public void setSelected(boolean selected) {
        this.selectCheckBox.setSelected(selected);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPreviewSelected(boolean selected) {
        this.setStyle(selected ? BORDER_SELECTED : BORDER_UNSELECTED);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean isImageLoaded() {
        return this.imageLoaded;
    }

    public void setThumbnail(Image thumbnail) {
        this.imageView.setImage(thumbnail);
        this.imageLoaded = thumbnail != null;
    }

    public void clearThumbnail(Image placeholder) {
        this.imageView.setImage(placeholder);
        this.imageLoaded = false;
    }

    public void setRotation(int degrees) {
        this.rotation = degrees;
        this.imageView.setRotate(degrees);
        if (degrees != 0) {
            this.pageLabel.setText("Page " + this.pageNumber + " (" + degrees + "\u00b0)");
        } else {
            this.pageLabel.setText("Page " + this.pageNumber);
        }
        logger.trace("Page {} rotation set to {}", (Object)this.pageNumber, (Object)degrees);
    }

    public int getRotation() {
        return this.rotation;
    }
}

