/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.ui.joiner.components;

import com.datmt.pdftools.model.JoinerSection;
import java.util.function.Consumer;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionListItem
extends VBox {
    private static final Logger logger = LoggerFactory.getLogger(SectionListItem.class);
    private static final String STYLE_NORMAL = "-fx-background-color: white; -fx-border-color: #e0e0e0; -fx-border-radius: 3; -fx-cursor: hand;";
    private static final String STYLE_SELECTED = "-fx-background-color: #e3f2fd; -fx-border-color: #2196F3; -fx-border-radius: 3; -fx-border-width: 2; -fx-cursor: hand;";
    private final JoinerSection section;
    private final Label indexLabel;
    private boolean isSelected;

    public SectionListItem(JoinerSection section, int index, Consumer<SectionListItem> onSelect, Consumer<SectionListItem> onMoveUp, Consumer<SectionListItem> onMoveDown, Consumer<SectionListItem> onRotateLeft, Consumer<SectionListItem> onRotateRight, Consumer<SectionListItem> onRemove) {
        this.section = section;
        this.isSelected = false;
        this.setSpacing(4.0);
        this.setPadding(new Insets(8.0));
        this.setStyle(STYLE_NORMAL);
        HBox headerRow = new HBox(4.0);
        headerRow.setAlignment(Pos.CENTER_LEFT);
        this.indexLabel = new Label("Section " + index);
        this.indexLabel.setStyle("-fx-font-weight: bold; -fx-font-size: 12;");
        HBox.setHgrow(this.indexLabel, Priority.ALWAYS);
        Button upBtn = this.createIconButton("\u25b2", "Move up", onMoveUp);
        Button downBtn = this.createIconButton("\u25bc", "Move down", onMoveDown);
        Button rotateLeftBtn = this.createIconButton("\u21ba", "Rotate left", onRotateLeft);
        Button rotateRightBtn = this.createIconButton("\u21bb", "Rotate right", onRotateRight);
        Button removeBtn = this.createIconButton("\u2715", "Remove", onRemove);
        removeBtn.setStyle("-fx-background-color: transparent; -fx-text-fill: #999; -fx-font-size: 12; -fx-cursor: hand; -fx-min-width: 24;");
        removeBtn.setOnMouseEntered(e -> removeBtn.setStyle("-fx-background-color: transparent; -fx-text-fill: #d32f2f; -fx-font-size: 12; -fx-cursor: hand; -fx-min-width: 24;"));
        removeBtn.setOnMouseExited(e -> removeBtn.setStyle("-fx-background-color: transparent; -fx-text-fill: #999; -fx-font-size: 12; -fx-cursor: hand; -fx-min-width: 24;"));
        headerRow.getChildren().addAll((Node[])new Node[]{this.indexLabel, upBtn, downBtn, rotateLeftBtn, rotateRightBtn, removeBtn});
        Label fileLabel = new Label(section.getSourceFile().getFileName());
        fileLabel.setStyle("-fx-font-size: 11;");
        fileLabel.setWrapText(true);
        Label pagesLabel = new Label(section.getPageRangeString());
        pagesLabel.setStyle("-fx-font-size: 10; -fx-text-fill: #666;");
        String countText = section.getPageCount() + " page" + (section.getPageCount() > 1 ? "s" : "");
        int rotationDegrees = section.getRotation().getDegrees();
        if (rotationDegrees != 0) {
            countText = countText + " | Rotated " + rotationDegrees + "\u00b0";
        }
        Label countLabel = new Label(countText);
        countLabel.setStyle("-fx-font-size: 10; -fx-text-fill: #888;");
        this.getChildren().addAll((Node[])new Node[]{headerRow, fileLabel, pagesLabel, countLabel});
        this.setOnMouseClicked(event -> {
            if (!(event.getTarget() instanceof Button) && onSelect != null) {
                onSelect.accept(this);
            }
        });
        logger.trace("Created SectionListItem for: {} ({})", (Object)section.getSourceFile().getFileName(), (Object)section.getPageRangeString());
    }

    private Button createIconButton(String icon, String tooltip, Consumer<SectionListItem> action) {
        Button btn = new Button(icon);
        btn.setStyle("-fx-background-color: transparent; -fx-text-fill: #666; -fx-font-size: 10; -fx-cursor: hand; -fx-min-width: 24;");
        btn.setOnMouseEntered(e -> btn.setStyle("-fx-background-color: #e0e0e0; -fx-text-fill: #333; -fx-font-size: 10; -fx-cursor: hand; -fx-min-width: 24;"));
        btn.setOnMouseExited(e -> btn.setStyle("-fx-background-color: transparent; -fx-text-fill: #666; -fx-font-size: 10; -fx-cursor: hand; -fx-min-width: 24;"));
        btn.setOnAction(e -> {
            e.consume();
            if (action != null) {
                action.accept(this);
            }
        });
        return btn;
    }

    public JoinerSection getSection() {
        return this.section;
    }

    public void setIndex(int index) {
        this.indexLabel.setText("Section " + index);
    }

    public boolean isSectionSelected() {
        return this.isSelected;
    }

    public void setSectionSelected(boolean selected) {
        this.isSelected = selected;
        this.setStyle(selected ? STYLE_SELECTED : STYLE_NORMAL);
    }
}

