/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.ui.security;

import com.datmt.pdftools.service.PdfSecurityService;
import com.datmt.pdftools.util.CreditLinkHandler;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSecurityController {
    private static final Logger logger = LoggerFactory.getLogger(PdfSecurityController.class);
    @FXML
    private Button selectFileButton;
    @FXML
    private Label fileNameLabel;
    @FXML
    private Label statusLabel;
    @FXML
    private PasswordField userPasswordField;
    @FXML
    private PasswordField ownerPasswordField;
    @FXML
    private CheckBox allowPrintingCheck;
    @FXML
    private CheckBox allowCopyingCheck;
    @FXML
    private CheckBox allowEditingCheck;
    @FXML
    private CheckBox allowFormsCheck;
    @FXML
    private Button protectButton;
    @FXML
    private PasswordField currentPasswordField;
    @FXML
    private Label verifyStatusLabel;
    @FXML
    private Button verifyButton;
    @FXML
    private Button removeProtectionButton;
    @FXML
    private VBox pdfInfoSection;
    @FXML
    private Label encryptionStatusLabel;
    @FXML
    private Label permissionsInfoLabel;
    @FXML
    private RadioButton saveAsNewRadio;
    @FXML
    private RadioButton overwriteOriginalRadio;
    @FXML
    private ToggleGroup outputToggleGroup;
    @FXML
    private HBox resultSection;
    @FXML
    private Label resultLabel;
    @FXML
    private Hyperlink creditLink;
    private File selectedFile;
    private boolean isEncrypted = false;
    private boolean passwordVerified = false;
    private final PdfSecurityService securityService = new PdfSecurityService();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    @FXML
    public void initialize() {
        logger.info("Initializing PDF Security");
        this.setupWindowCloseHandler();
        this.setupListeners();
        CreditLinkHandler.setup(this.creditLink);
        this.updateUI();
    }

    private void setupWindowCloseHandler() {
        Platform.runLater(() -> {
            if (this.selectFileButton.getScene() != null && this.selectFileButton.getScene().getWindow() != null) {
                this.selectFileButton.getScene().getWindow().setOnCloseRequest(event -> this.cleanup());
            }
        });
    }

    private void setupListeners() {
        this.ownerPasswordField.textProperty().addListener((obs, oldVal, newVal) -> this.updateUI());
        this.currentPasswordField.textProperty().addListener((obs, oldVal, newVal) -> {
            this.passwordVerified = false;
            this.verifyStatusLabel.setText("");
            this.updateUI();
        });
    }

    @FXML
    private void onSelectFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select PDF File");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("PDF Files", "*.pdf"));
        File file = fileChooser.showOpenDialog(this.selectFileButton.getScene().getWindow());
        if (file != null) {
            this.selectFile(file);
        }
    }

    private void selectFile(File file) {
        this.selectedFile = file;
        this.fileNameLabel.setText(file.getName());
        this.passwordVerified = false;
        this.verifyStatusLabel.setText("");
        this.currentPasswordField.clear();
        this.resultSection.setVisible(false);
        this.resultSection.setManaged(false);
        this.executor.submit(() -> {
            try {
                this.isEncrypted = this.securityService.isProtected(file);
                PdfSecurityService.SecurityInfo info = null;
                try {
                    info = this.securityService.getSecurityInfo(file, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PdfSecurityService.SecurityInfo finalInfo = info;
                Platform.runLater(() -> {
                    if (this.isEncrypted) {
                        this.statusLabel.setText("Protected");
                        this.statusLabel.setStyle("-fx-font-size: 13; -fx-font-weight: bold; -fx-text-fill: #ff5722;");
                        this.encryptionStatusLabel.setText("Status: Password protected");
                    } else {
                        this.statusLabel.setText("Unprotected");
                        this.statusLabel.setStyle("-fx-font-size: 13; -fx-font-weight: bold; -fx-text-fill: #4caf50;");
                        this.encryptionStatusLabel.setText("Status: No password protection");
                    }
                    if (finalInfo != null && finalInfo.getPermissions() != null) {
                        PdfSecurityService.Permissions perms = finalInfo.getPermissions();
                        this.permissionsInfoLabel.setText(String.format("Print: %s | Copy: %s | Edit: %s | Forms: %s", perms.isCanPrint() ? "Yes" : "No", perms.isCanCopy() ? "Yes" : "No", perms.isCanModify() ? "Yes" : "No", perms.isCanFillForms() ? "Yes" : "No"));
                    } else {
                        this.permissionsInfoLabel.setText("");
                    }
                    this.pdfInfoSection.setVisible(true);
                    this.pdfInfoSection.setManaged(true);
                    this.updateUI();
                });
            }
            catch (Exception e) {
                logger.error("Error checking file security: {}", (Object)e.getMessage());
                Platform.runLater(() -> {
                    this.statusLabel.setText("Error");
                    this.statusLabel.setStyle("-fx-font-size: 13; -fx-font-weight: bold; -fx-text-fill: #cc0000;");
                });
            }
        });
    }

    @FXML
    private void onVerifyPassword() {
        if (this.selectedFile == null) {
            return;
        }
        String password = this.currentPasswordField.getText();
        if (password.isEmpty()) {
            this.verifyStatusLabel.setText("Please enter a password");
            this.verifyStatusLabel.setStyle("-fx-font-size: 12; -fx-text-fill: #cc0000;");
            return;
        }
        this.verifyButton.setDisable(true);
        this.verifyStatusLabel.setText("Verifying...");
        this.verifyStatusLabel.setStyle("-fx-font-size: 12; -fx-text-fill: #666666;");
        this.executor.submit(() -> {
            boolean valid = this.securityService.verifyPassword(this.selectedFile, password);
            Platform.runLater(() -> {
                this.verifyButton.setDisable(false);
                this.passwordVerified = valid;
                if (valid) {
                    this.verifyStatusLabel.setText("Password correct!");
                    this.verifyStatusLabel.setStyle("-fx-font-size: 12; -fx-text-fill: #4caf50; -fx-font-weight: bold;");
                } else {
                    this.verifyStatusLabel.setText("Incorrect password");
                    this.verifyStatusLabel.setStyle("-fx-font-size: 12; -fx-text-fill: #cc0000;");
                }
                this.updateUI();
            });
        });
    }

    @FXML
    private void onProtect() {
        if (this.selectedFile == null) {
            return;
        }
        String ownerPassword = this.ownerPasswordField.getText();
        if (ownerPassword.isEmpty()) {
            this.showResult("Owner password is required", false);
            return;
        }
        String userPassword = this.userPasswordField.getText();
        PdfSecurityService.Permissions permissions = new PdfSecurityService.Permissions();
        permissions.setCanPrint(this.allowPrintingCheck.isSelected());
        permissions.setCanCopy(this.allowCopyingCheck.isSelected());
        permissions.setCanModify(this.allowEditingCheck.isSelected());
        permissions.setCanFillForms(this.allowFormsCheck.isSelected());
        File outputFile = this.getOutputFile(this.selectedFile, "_protected");
        if (outputFile == null) {
            return;
        }
        this.protectButton.setDisable(true);
        this.showResult("Protecting PDF...", true);
        this.executor.submit(() -> {
            try {
                this.securityService.protectPdf(this.selectedFile, outputFile, userPassword, ownerPassword, permissions);
                if (this.overwriteOriginalRadio.isSelected()) {
                    if (this.selectedFile.delete() && outputFile.renameTo(this.selectedFile)) {
                        Platform.runLater(() -> this.showResult("PDF protected successfully (overwritten)", true));
                    } else {
                        Platform.runLater(() -> this.showResult("Protected PDF saved as: " + outputFile.getName(), true));
                    }
                } else {
                    Platform.runLater(() -> this.showResult("Protected PDF saved as: " + outputFile.getName(), true));
                }
            }
            catch (Exception e) {
                logger.error("Failed to protect PDF: {}", (Object)e.getMessage(), (Object)e);
                Platform.runLater(() -> this.showResult("Failed: " + e.getMessage(), false));
            }
            finally {
                Platform.runLater(() -> {
                    this.protectButton.setDisable(false);
                    if (this.selectedFile.exists()) {
                        this.selectFile(this.selectedFile);
                    }
                });
            }
        });
    }

    @FXML
    private void onRemoveProtection() {
        if (this.selectedFile == null || !this.passwordVerified) {
            return;
        }
        String password = this.currentPasswordField.getText();
        File outputFile = this.getOutputFile(this.selectedFile, "_unprotected");
        if (outputFile == null) {
            return;
        }
        this.removeProtectionButton.setDisable(true);
        this.showResult("Removing protection...", true);
        this.executor.submit(() -> {
            try {
                this.securityService.removeProtection(this.selectedFile, outputFile, password);
                if (this.overwriteOriginalRadio.isSelected()) {
                    if (this.selectedFile.delete() && outputFile.renameTo(this.selectedFile)) {
                        Platform.runLater(() -> this.showResult("Protection removed successfully (overwritten)", true));
                    } else {
                        Platform.runLater(() -> this.showResult("Unprotected PDF saved as: " + outputFile.getName(), true));
                    }
                } else {
                    Platform.runLater(() -> this.showResult("Unprotected PDF saved as: " + outputFile.getName(), true));
                }
            }
            catch (Exception e) {
                logger.error("Failed to remove protection: {}", (Object)e.getMessage(), (Object)e);
                Platform.runLater(() -> this.showResult("Failed: " + e.getMessage(), false));
            }
            finally {
                Platform.runLater(() -> {
                    this.removeProtectionButton.setDisable(false);
                    this.passwordVerified = false;
                    this.currentPasswordField.clear();
                    this.verifyStatusLabel.setText("");
                    if (this.selectedFile.exists()) {
                        this.selectFile(this.selectedFile);
                    }
                });
            }
        });
    }

    private File getOutputFile(File inputFile, String suffix) {
        if (this.overwriteOriginalRadio.isSelected()) {
            return new File(inputFile.getParent(), inputFile.getName().replace(".pdf", "_temp.pdf"));
        }
        return new File(inputFile.getParent(), inputFile.getName().replace(".pdf", suffix + ".pdf"));
    }

    private void showResult(String message, boolean success) {
        this.resultSection.setVisible(true);
        this.resultSection.setManaged(true);
        this.resultLabel.setText(message);
        if (success) {
            this.resultLabel.setStyle("-fx-font-size: 13; -fx-text-fill: #4caf50;");
        } else {
            this.resultLabel.setStyle("-fx-font-size: 13; -fx-text-fill: #cc0000;");
        }
    }

    private void updateUI() {
        boolean hasFile = this.selectedFile != null;
        this.protectButton.setDisable(!hasFile || this.ownerPasswordField.getText().isEmpty());
        this.verifyButton.setDisable(!hasFile || !this.isEncrypted || this.currentPasswordField.getText().isEmpty());
        this.removeProtectionButton.setDisable(!hasFile || !this.isEncrypted || !this.passwordVerified);
    }

    public void cleanup() {
        logger.info("Cleaning up PDF Security");
        this.executor.shutdownNow();
    }
}

