/*
 * Decompiled with CFR 0.152.
 */
package com.datmt.pdftools.util;

import javafx.scene.control.Hyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditLinkHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreditLinkHandler.class);
    private static final String BASE_URL = "https://tools.datmt.com";

    public static void setup(Hyperlink creditLink) {
        if (creditLink == null) {
            logger.info("Credit link is null, skipping setup");
            return;
        }
        creditLink.setOnAction(event -> CreditLinkHandler.openUrl(CreditLinkHandler.buildUrl()));
    }

    private static String buildUrl() {
        String os = CreditLinkHandler.getOsName();
        return "https://tools.datmt.com?src=pdf-tools&os=" + os;
    }

    private static String getOsName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux")) {
            return "linux";
        }
        if (os.contains("mac")) {
            return "macos";
        }
        if (os.contains("win")) {
            return "windows";
        }
        return "unknown";
    }

    private static void openUrl(String url) {
        try {
            ProcessBuilder pb;
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("linux")) {
                pb = new ProcessBuilder("xdg-open", url);
            } else if (os.contains("mac")) {
                pb = new ProcessBuilder("open", url);
            } else if (os.contains("win")) {
                pb = new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url);
            } else {
                logger.warn("Unsupported OS for opening URL: {}", (Object)os);
                return;
            }
            pb.inheritIO();
            pb.start();
            logger.info("Opened credit link: {}", (Object)url);
        }
        catch (Exception e) {
            logger.error("Failed to open credit link: {}", (Object)e.getMessage());
        }
    }
}

