/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.Language;
import org.apache.fontbox.ttf.model.MapBackedGsubData;
import org.apache.fontbox.ttf.table.common.CoverageTable;
import org.apache.fontbox.ttf.table.common.FeatureListTable;
import org.apache.fontbox.ttf.table.common.FeatureRecord;
import org.apache.fontbox.ttf.table.common.LangSysTable;
import org.apache.fontbox.ttf.table.common.LookupListTable;
import org.apache.fontbox.ttf.table.common.LookupSubTable;
import org.apache.fontbox.ttf.table.common.LookupTable;
import org.apache.fontbox.ttf.table.common.ScriptTable;
import org.apache.fontbox.ttf.table.gsub.LigatureSetTable;
import org.apache.fontbox.ttf.table.gsub.LigatureTable;
import org.apache.fontbox.ttf.table.gsub.LookupTypeLigatureSubstitutionSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeMultipleSubstitutionFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat2;
import org.apache.fontbox.ttf.table.gsub.SequenceTable;

public class GlyphSubstitutionDataExtractor {
    private static final Log LOG = LogFactory.getLog(GlyphSubstitutionDataExtractor.class);

    public GsubData getGsubData(Map<String, ScriptTable> scriptList, FeatureListTable featureListTable, LookupListTable lookupListTable) {
        ScriptTableDetails scriptTableDetails = this.getSupportedLanguage(scriptList);
        if (scriptTableDetails == null) {
            return GsubData.NO_DATA_FOUND;
        }
        return this.buildMapBackedGsubData(featureListTable, lookupListTable, scriptTableDetails);
    }

    public GsubData getGsubData(String scriptName, ScriptTable scriptTable, FeatureListTable featureListTable, LookupListTable lookupListTable) {
        ScriptTableDetails scriptTableDetails = new ScriptTableDetails(Language.UNSPECIFIED, scriptName, scriptTable);
        return this.buildMapBackedGsubData(featureListTable, lookupListTable, scriptTableDetails);
    }

    private MapBackedGsubData buildMapBackedGsubData(FeatureListTable featureListTable, LookupListTable lookupListTable, ScriptTableDetails scriptTableDetails) {
        ScriptTable scriptTable = scriptTableDetails.getScriptTable();
        LinkedHashMap<String, Map<List<Integer>, Integer>> gsubData = new LinkedHashMap<String, Map<List<Integer>, Integer>>();
        if (scriptTable.getDefaultLangSysTable() != null) {
            this.populateGsubData(gsubData, scriptTable.getDefaultLangSysTable(), featureListTable, lookupListTable);
        }
        for (LangSysTable langSysTable : scriptTable.getLangSysTables().values()) {
            this.populateGsubData(gsubData, langSysTable, featureListTable, lookupListTable);
        }
        return new MapBackedGsubData(scriptTableDetails.getLanguage(), scriptTableDetails.getFeatureName(), gsubData);
    }

    private ScriptTableDetails getSupportedLanguage(Map<String, ScriptTable> scriptList) {
        for (Language lang : Language.values()) {
            for (String scriptName : lang.getScriptNames()) {
                ScriptTable value = scriptList.get(scriptName);
                if (value == null) continue;
                return new ScriptTableDetails(lang, scriptName, value);
            }
        }
        return null;
    }

    private void populateGsubData(Map<String, Map<List<Integer>, Integer>> gsubData, LangSysTable langSysTable, FeatureListTable featureListTable, LookupListTable lookupListTable) {
        FeatureRecord[] featureRecords = featureListTable.getFeatureRecords();
        for (int featureIndex : langSysTable.getFeatureIndices()) {
            if (featureIndex >= featureRecords.length) continue;
            this.populateGsubData(gsubData, featureRecords[featureIndex], lookupListTable);
        }
    }

    private void populateGsubData(Map<String, Map<List<Integer>, Integer>> gsubData, FeatureRecord featureRecord, LookupListTable lookupListTable) {
        LookupTable[] lookups = lookupListTable.getLookups();
        LinkedHashMap<List<Integer>, Integer> glyphSubstitutionMap = new LinkedHashMap<List<Integer>, Integer>();
        for (int lookupIndex : featureRecord.getFeatureTable().getLookupListIndices()) {
            if (lookupIndex >= lookups.length) continue;
            this.extractData(glyphSubstitutionMap, lookups[lookupIndex]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("*********** extracting GSUB data for the feature: " + featureRecord.getFeatureTag() + ", glyphSubstitutionMap: " + glyphSubstitutionMap);
        }
        gsubData.put(featureRecord.getFeatureTag(), Collections.unmodifiableMap(glyphSubstitutionMap));
    }

    private void extractData(Map<List<Integer>, Integer> glyphSubstitutionMap, LookupTable lookupTable) {
        for (LookupSubTable lookupSubTable : lookupTable.getSubTables()) {
            if (lookupSubTable instanceof LookupTypeLigatureSubstitutionSubstFormat1) {
                this.extractDataFromLigatureSubstitutionSubstFormat1Table(glyphSubstitutionMap, (LookupTypeLigatureSubstitutionSubstFormat1)lookupSubTable);
                continue;
            }
            if (lookupSubTable instanceof LookupTypeSingleSubstFormat1) {
                this.extractDataFromSingleSubstTableFormat1Table(glyphSubstitutionMap, (LookupTypeSingleSubstFormat1)lookupSubTable);
                continue;
            }
            if (lookupSubTable instanceof LookupTypeSingleSubstFormat2) {
                this.extractDataFromSingleSubstTableFormat2Table(glyphSubstitutionMap, (LookupTypeSingleSubstFormat2)lookupSubTable);
                continue;
            }
            if (lookupSubTable instanceof LookupTypeMultipleSubstitutionFormat1) {
                this.extractDataFromMultipleSubstitutionFormat1Table(glyphSubstitutionMap, (LookupTypeMultipleSubstitutionFormat1)lookupSubTable);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("The type " + lookupSubTable + " is not yet supported, will be ignored");
        }
    }

    private void extractDataFromSingleSubstTableFormat1Table(Map<List<Integer>, Integer> glyphSubstitutionMap, LookupTypeSingleSubstFormat1 singleSubstTableFormat1) {
        CoverageTable coverageTable = singleSubstTableFormat1.getCoverageTable();
        for (int i = 0; i < coverageTable.getSize(); ++i) {
            int coverageGlyphId = coverageTable.getGlyphId(i);
            int substituteGlyphId = coverageGlyphId + singleSubstTableFormat1.getDeltaGlyphID();
            this.putNewSubstitutionEntry(glyphSubstitutionMap, substituteGlyphId, Collections.singletonList(coverageGlyphId));
        }
    }

    private void extractDataFromSingleSubstTableFormat2Table(Map<List<Integer>, Integer> glyphSubstitutionMap, LookupTypeSingleSubstFormat2 singleSubstTableFormat2) {
        CoverageTable coverageTable = singleSubstTableFormat2.getCoverageTable();
        if (coverageTable.getSize() != singleSubstTableFormat2.getSubstituteGlyphIDs().length) {
            LOG.warn("The coverage table size (" + coverageTable.getSize() + ") should be the same as the count of the substituteGlyphIDs tables (" + singleSubstTableFormat2.getSubstituteGlyphIDs().length + ")");
            return;
        }
        for (int i = 0; i < coverageTable.getSize(); ++i) {
            int coverageGlyphId = coverageTable.getGlyphId(i);
            int substituteGlyphId = coverageGlyphId + singleSubstTableFormat2.getSubstituteGlyphIDs()[i];
            this.putNewSubstitutionEntry(glyphSubstitutionMap, substituteGlyphId, Collections.singletonList(coverageGlyphId));
        }
    }

    private void extractDataFromMultipleSubstitutionFormat1Table(Map<List<Integer>, Integer> glyphSubstitutionMap, LookupTypeMultipleSubstitutionFormat1 multipleSubstFormat1Subtable) {
        CoverageTable coverageTable = multipleSubstFormat1Subtable.getCoverageTable();
        if (coverageTable.getSize() != multipleSubstFormat1Subtable.getSequenceTables().length) {
            LOG.warn("The coverage table size (" + coverageTable.getSize() + ") should be the same as the count of the sequence tables (" + multipleSubstFormat1Subtable.getSequenceTables().length + ")");
            return;
        }
        for (int i = 0; i < coverageTable.getSize(); ++i) {
            int coverageGlyphId = coverageTable.getGlyphId(i);
            SequenceTable sequenceTable = multipleSubstFormat1Subtable.getSequenceTables()[i];
        }
    }

    private void extractDataFromLigatureSubstitutionSubstFormat1Table(Map<List<Integer>, Integer> glyphSubstitutionMap, LookupTypeLigatureSubstitutionSubstFormat1 ligatureSubstitutionTable) {
        for (LigatureSetTable ligatureSetTable : ligatureSubstitutionTable.getLigatureSetTables()) {
            for (LigatureTable ligatureTable : ligatureSetTable.getLigatureTables()) {
                this.extractDataFromLigatureTable(glyphSubstitutionMap, ligatureTable);
            }
        }
    }

    private void extractDataFromLigatureTable(Map<List<Integer>, Integer> glyphSubstitutionMap, LigatureTable ligatureTable) {
        int[] componentGlyphIDs = ligatureTable.getComponentGlyphIDs();
        ArrayList<Integer> glyphsToBeSubstituted = new ArrayList<Integer>(componentGlyphIDs.length);
        for (int componentGlyphID : componentGlyphIDs) {
            glyphsToBeSubstituted.add(componentGlyphID);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("glyphsToBeSubstituted: " + glyphsToBeSubstituted);
        }
        this.putNewSubstitutionEntry(glyphSubstitutionMap, ligatureTable.getLigatureGlyph(), glyphsToBeSubstituted);
    }

    private void putNewSubstitutionEntry(Map<List<Integer>, Integer> glyphSubstitutionMap, int newGlyph, List<Integer> glyphsToBeSubstituted) {
        Integer oldValue = glyphSubstitutionMap.put(glyphsToBeSubstituted, newGlyph);
        if (oldValue != null && LOG.isDebugEnabled()) {
            String message = "For the newGlyph: " + newGlyph + ", newValue: " + glyphsToBeSubstituted + " is trying to override the oldValue: " + oldValue;
            LOG.debug(message);
        }
    }

    private static class ScriptTableDetails {
        private final Language language;
        private final String featureName;
        private final ScriptTable scriptTable;

        private ScriptTableDetails(Language language, String featureName, ScriptTable scriptTable) {
            this.language = language;
            this.featureName = featureName;
            this.scriptTable = scriptTable;
        }

        public Language getLanguage() {
            return this.language;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public ScriptTable getScriptTable() {
            return this.scriptTable;
        }
    }
}

